﻿#Update $RegistryPath Value for your Environment. 
$RegistryPath = "HKLM:\SOFTWARE\WaaS"
$RegistryRollBack = "HKLM:\SYSTEM\Setup\Rollback"
$LogFile = "C:\Windows\ccm\Logs\WaaS_RollbackRecovery.log"
$LastOSUpgradeFrom = Get-ItemPropertyValue -Path "$RegistryPath" -Name LastOSUpgradeFrom
$LastOSUpgradeTo = Get-ItemPropertyValue -Path "$RegistryPath" -Name LastOSUpgradeTo
$RegistryPathFull = "$RegistryPath\$LastOSUpgradeTo"
$WaaSStage = Get-ItemPropertyValue "$RegistryPathFull" 'WaaS_Stage' -ErrorAction SilentlyContinue
$ScriptName = $MyInvocation.MyCommand.Name

$legalnoticecaption = "WARNING"
$legalnoticetext = "WARNING. You have accessed a private computer system. Unauthorized access, use, connection, or entry is not permitted and constitutes a crime punishable by law. We reserve the right to fully pursue criminal and civil legal penalties. All individuals using this computer system with or without proper authority are subject to having all their activities monitored and recorded. Anyone using this system implicitly consents to this monitoring. Any evidence of suspected criminal activity revealed by such monitoring may be provided to law enforcement officials."

# Schedule Task Names
$DefaultSTN = "WaaS_SetLegalNoticeText-Default"
$OSUpgradeCompleteSTN = "WaaS_SetLegalNoticeText-OSUpgradeComplete"
$OSUninstallSuccessfulSTN = "WaaS_SetLegalNoticeText-OSUninstallSuccessful"
$OSUninstallSTN = "WaaS_SetLegalNoticeText-OSUninstall"
$OSUninstallDefaultSTN = "WaaS_SetLegalNoticeText-OSUninstallDefault"
$ForceLockScreenCleanup2HoursSTN = "WaaS_ForceLockScreenCleanup2Hours"
$LockScreenCleanUpSTN = "WaaS_LockScreenCleanUp"
$OSUninstallCleanUpSTN = "WaaS_OSUninstallCleanUp"
$Post_OSUninstall_ProcessesSTN = "WaaS_Post_OSUninstall_Processes"
$RollBackRecoverySTN = "WaaS_SetLegalNoticeText-RollBackRecovery"
$RollBackRecoveryDefaultSTN = "WaaS_SetLegalNoticeText-RollBackRecoveryDefault"
$RollBackRecovery_Process_DownlevelSTN = "WaaS_RollBackRecovery_Process_Downlevel"
$RollBackRecovery_Process_Phase2STN = "WaaS_RollBackRecovery_Process_Phase2"
$RollBackRecovery_CleanUpSTN = "WaaS_RollBackRecovery_CleanUp"


#region: CMTraceLog Function formats logging in CMTrace style
        function CMTraceLog {
         [CmdletBinding()]
    Param (
		    [Parameter(Mandatory=$false)]
		    $Message,
 
		    [Parameter(Mandatory=$false)]
		    $ErrorMessage,
 
		    [Parameter(Mandatory=$false)]
		    $Component = $env:computername,
 
		    [Parameter(Mandatory=$false)]
		    [int]$Type,
		
		    [Parameter(Mandatory=$true)]
		    $LogFile
	    )
    <#
    Type: 1 = Normal, 2 = Warning (yellow), 3 = Error (red)
    #>
	    $Time = Get-Date -Format "HH:mm:ss.ffffff"
	    $Date = Get-Date -Format "MM-dd-yyyy"
 
	    if ($ErrorMessage -ne $null) {$Type = 3}
	    if ($Component -eq $null) {$Component = " "}
	    if ($Type -eq $null) {$Type = 1}
 
	    $LogMessage = "<![LOG[$Message $ErrorMessage" + "]LOG]!><time=`"$Time`" date=`"$Date`" component=`"$Component`" context=`"`" type=`"$Type`" thread=`"`" file=`"`">"
	    $LogMessage | Out-File -Append -Encoding UTF8 -FilePath $LogFile
    }

if ($WaaSStage -eq "Deployment_RollBack") #OSUninstall is set using a OSUninstall TS post Upgrade, to allow being reverted, so this will never run if this key isn't set by the OSUninstall TS
    {
    CMTraceLog -Message  "---Starting $ScriptName Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticecaption -Value $legalnoticecaption
    Set-ItemProperty -Path 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' -Name legalnoticetext -Value $legalnoticetext
    CMTraceLog -Message  "Updated Values: legalnoticecaption & legalnoticetext" -Type 1 -LogFile $LogFile -Component LegalText-Default
    $CurrentLegalCaption = Get-ItemPropertyValue 'HKLM:\Software\Microsoft\Windows\CurrentVersion\Policies\System' 'legalnoticecaption' -ErrorAction SilentlyContinue
    CMTraceLog -Message  "LegalCaption Data Currently: $CurrentLegalCaption" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUninstallSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $OSUninstallDefaultSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $Post_OSUninstall_ProcessesSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $OSUninstallCleanUpSTN -Confirm:$false -ErrorAction SilentlyContinue
    CMTraceLog -Message  "Removed Scheduled Tasks for OSUninstall" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $RollBackRecoverySTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $RollBackRecoveryDefaultSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $RollBackRecovery_Process_DownlevelSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $RollBackRecovery_Process_Phase2STN -Confirm:$false -ErrorAction SilentlyContinue
    CMTraceLog -Message  "Removed Scheduled Tasks for RollBackRecovery" -Type 1 -LogFile $LogFile -Component LegalText-Default
                    
    Start-ScheduledTask -TaskName $RollBackRecovery_CleanUpSTN
    CMTraceLog -Message  "Triggering $RollBackRecovery_CleanUpSTN Scheduled Task" -Type 1 -LogFile $LogFile
    
    CMTraceLog -Message  "---Exiting $ScriptName Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    }

if ($WaaSStage -eq "OSUninstallComplete")
    {
    CMTraceLog -Message  "---Starting $ScriptName Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $OSUninstallSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $OSUninstallDefaultSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $Post_OSUninstall_ProcessesSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $OSUninstallCleanUpSTN -Confirm:$false -ErrorAction SilentlyContinue
    CMTraceLog -Message  "Removed Scheduled Tasks for OSUninstall" -Type 1 -LogFile $LogFile -Component LegalText-Default
    Unregister-ScheduledTask -TaskName $RollBackRecoverySTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $RollBackRecoveryDefaultSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $RollBackRecovery_Process_DownlevelSTN -Confirm:$false -ErrorAction SilentlyContinue
    Unregister-ScheduledTask -TaskName $RollBackRecovery_Process_Phase2STN -Confirm:$false -ErrorAction SilentlyContinue
    CMTraceLog -Message  "Removed Scheduled Tasks for RollBackRecovery" -Type 1 -LogFile $LogFile -Component LegalText-Default
    CMTraceLog -Message  "---Exiting $ScriptName Script---" -Type 1 -LogFile $LogFile -Component LegalText-Default
    }